VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
END
Attribute VB_Name = "DCustomers"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Attribute VB_Ext_KEY = "RVB_UniqueId" ,"33E103B0039A"
'
Option Base 0
Option Explicit
Implements ObjectControl

Private oDb As ADODB.Connection
Private oRs As ADODB.Recordset

Private oObjectContext As ObjectContext

Private Function ObjectControl_CanBePooled() As Boolean
    ObjectControl_CanBePooled = True
End Function

Private Sub ObjectControl_Deactivate()
    Set oObjectContext = Nothing
    Set oDb = Nothing
    Set oRs = Nothing
End Sub

Private Sub ObjectControl_Activate()
    On Error GoTo OCActivateErr
   
    Set oObjectContext = GetObjectContext()
        
    Exit Sub

OCActivateErr:
    Call RaiseError("OCActivate")

End Sub

Public Function UpdateCustomer(ByVal vCustData As Variant) As Variant
    On Error GoTo UpdateCustomerErr
           
    Dim vResponse As New Collection
    Dim vSql As Variant
    
    Let vSql = "SELECT * FROM CUSTOMERS " & _
               " WHERE email = '" & LCase(vCustData("email")) & "';"
            
    Set oRs = oObjectContext.CreateInstance("ADODB.Recordset")
    oRs.CursorType = adOpenDynamic
    oRs.LockType = adLockPessimistic
    oRs.Open vSql, vDbConn
    
    oRs.Fields("Email") = Trim(LCase(vCustData("email")))
    oRs.Fields("Passcode") = Trim(vCustData("passcode"))
    oRs.Fields("Firstname") = Left(Trim(vCustData("firstname")), 25)
    oRs.Fields("Surname") = Left(Trim(vCustData("surname")), 25)
    oRs.Fields("Address") = Left(Trim(vCustData("address")), 40)
    oRs.Fields("City") = Left(Trim(vCustData("city")), 20)
    oRs.Fields("State") = Left(Trim(vCustData("state")), 20)
    oRs.Fields("Zipcode") = Left(Trim(vCustData("zipcode")), 10)
    oRs.Fields("Country") = Left(Trim(vCustData("country")), 20)
    oRs.Fields("Phone") = Left(Trim(vCustData("phone")), 20)
    oRs.Fields("UseCookie") = Left(Trim(vCustData("UseCookie")), 1)
    oRs.Fields("Interests") = ExtractInterestCodes(vCustData("interests"))
    oRs.Update
    
    oRs.Close
    
    vResponse.Add False, Key:="error"
    
    oObjectContext.SetComplete
    Set UpdateCustomer = vResponse
      
    Exit Function
    
UpdateCustomerErr:
    oObjectContext.SetAbort
    Set UpdateCustomer = RaiseError("UpdateCustomer")
    
End Function

Public Function InsertCustomer(ByVal vCustData As Variant) As Variant
    On Error GoTo InsertCustomerErr
      
    Dim vResponse As New Collection
    Dim vCustData2 As New Collection
      
    Set oRs = oObjectContext.CreateInstance("ADODB.Recordset")
    
    oRs.Open "customers", vDbConn, adOpenKeyset, adLockPessimistic, adCmdTable
    oRs.AddNew
    oRs.Fields("Email") = LCase(vCustData("email"))
    oRs.Fields("Passcode") = LTrim(vCustData("passcode"))
    oRs.Fields("Firstname") = ""
    oRs.Fields("Surname") = ""
    oRs.Fields("Address") = ""
    oRs.Fields("City") = ""
    oRs.Fields("State") = ""
    oRs.Fields("Zipcode") = ""
    oRs.Fields("Country") = ""
    oRs.Fields("Phone") = ""
    oRs.Fields("UseCookie") = "N"
    oRs.Fields("Interests") = ""
    oRs.Update
        
    vCustData2.Add Trim(oRs.Fields("Email")), "email"
    vCustData2.Add Trim(oRs.Fields("Passcode")), "passcode"
    vCustData2.Add "", "firstname"
    vCustData2.Add "", "surname"
    vCustData2.Add "", "address"
    vCustData2.Add "", "city"
    vCustData2.Add "", "state"
    vCustData2.Add "", "zipcode"
    vCustData2.Add "", "country"
    vCustData2.Add "", "phone"
    vCustData2.Add "N", "usecookie"
    vCustData2.Add BuildInterests(""), "interests"
    
    vResponse.Add False, Key:="error"
    vResponse.Add True, Key:="exists"
    vResponse.Add vCustData2, "custdata"
    
    oRs.Close
    
    oObjectContext.SetComplete
    Set InsertCustomer = vResponse
    
    Exit Function
    
InsertCustomerErr:
    oObjectContext.SetAbort
    Set InsertCustomer = RaiseError("InsertCustomer")
    
End Function


Public Function SelectCustomer(ByVal vCustData As Variant) As Variant
    On Error GoTo SelectCustomerErr
      
    Dim vResponse As New Collection
    Dim vCustData2 As New Collection
    Dim vInterests As Variant
    Dim vSql As Variant
    
    Let vSql = "SELECT * FROM CUSTOMERS " & _
               " WHERE email = '" & LCase(vCustData("email")) & "';"
    Set oDb = oObjectContext.CreateInstance("ADODB.Connection")
    oDb.Open vDbConn
    Set oRs = oDb.Execute(vSql)
    
    If Not oRs.EOF Then
        
        vCustData2.Add Trim(oRs.Fields("Passcode")), "passcode"
        vCustData2.Add CStr(oRs.Fields("email")), "email"
        vCustData2.Add Trim(oRs.Fields("Firstname")), "firstname"
        vCustData2.Add Trim(oRs.Fields("Surname")), "surname"
        vCustData2.Add Trim(oRs.Fields("Address")), "address"
        vCustData2.Add Trim(oRs.Fields("City")), "city"
        vCustData2.Add Trim(oRs.Fields("State")), "state"
        vCustData2.Add Trim(oRs.Fields("Zipcode")), "zipcode"
        vCustData2.Add Trim(oRs.Fields("Country")), "country"
        vCustData2.Add Trim(oRs.Fields("Phone")), "phone"
        vCustData2.Add Trim(oRs.Fields("UseCookie")), "usecookie"
        Trace ("Building Interests")
        Set vInterests = BuildInterests(Trim(oRs.Fields("Interests")))
        vCustData2.Add vInterests, "interests"
        
        vResponse.Add True, Key:="exists"
        vResponse.Add vCustData2, "custdata"
    Else
        vResponse.Add False, Key:="exists"
    End If
    
    oDb.Close
    
    vResponse.Add False, Key:="error"
    
    oObjectContext.SetComplete
    Set SelectCustomer = vResponse
    
    Exit Function
    
SelectCustomerErr:
    oObjectContext.SetAbort
    Set SelectCustomer = RaiseError("SelectCustomer")
    
End Function

